
IF OBJECT_ID('EST_PROD_PRECIFICACAO_PRECO_VERBAS') IS NULL
	BEGIN
		CREATE TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_VERBAS](
			[CD_EMP] [int] NOT NULL,
			[CD_GRUPO] [int] NOT NULL,
			[CD_PROD] [int] NOT NULL,			
			[CD_VERBA] [int] NOT NULL,
			[VLR_VERBA] [MONEY] NOT NULL,
			[DT_INI_UTIL] [datetime] NULL,
			[DT_FIM_UTIL] [datetime] NULL,
			[STS_VERBA] [tinyint] NOT NULL,
		 CONSTRAINT [PK_EST_PROD_PRECIFICACAO_PRECO_VERBAS] PRIMARY KEY CLUSTERED 
		(
			[CD_EMP] ASC,
			[CD_GRUPO] ASC,
			[CD_PROD] ASC,			
			[CD_VERBA] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]

				
		ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_VERBAS]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECIFICACAO_PRECO_VERBAS_EST_PROD_PRECIFICACAO_VERBAS] FOREIGN KEY([CD_EMP], [CD_VERBA])
		REFERENCES [dbo].[EST_PROD_PRECIFICACAO_VERBAS] ([CD_EMP], [CD_VERBA])
		ON UPDATE CASCADE
		ON DELETE NO ACTION 
 
		ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_VERBAS] CHECK CONSTRAINT [FK_EST_PROD_PRECIFICACAO_PRECO_VERBAS_EST_PROD_PRECIFICACAO_VERBAS]
	
		ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_VERBAS] ADD CONSTRAINT [DF_EST_PROD_PRECIFICACAO_PRECO_VERBAS_VLR_VERBA] DEFAULT 0 FOR VLR_VERBA 
		
		ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_VERBAS] ADD CONSTRAINT [DF_EST_PROD_PRECIFICACAO_PRECO_VERBAS_STS_VERBA] DEFAULT 0 FOR STS_VERBA 
	
	END
